/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.preferences.PropertiesStorage;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public abstract class NbPreferences
extends AbstractPreferences
implements ChangeListener {
    private static Preferences USER_ROOT;
    private static Preferences SYSTEM_ROOT;
    private ThreadLocal<Boolean> localThread = new ThreadLocal();
    private ArrayList<String> keyEntries = new ArrayList();
    HashMap<String, ArrayList<String>> cachedKeyValues = new HashMap();
    EditableProperties properties;
    FileStorage fileStorage;
    private static final RequestProcessor RP;
    final RequestProcessor.Task flushTask = RP.create(new Runnable(){

        @Override
        public void run() {
            NbPreferences.this.fileStorage.runAtomic(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = NbPreferences.this.lock;
                    synchronized (object) {
                        try {
                            NbPreferences.this.flushSpi();
                        }
                        catch (BackingStoreException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
        }
    }, true);

    public static Preferences userRootImpl() {
        if (USER_ROOT == null) {
            USER_ROOT = new UserPreferences();
        }
        assert (USER_ROOT != null);
        return USER_ROOT;
    }

    public static Preferences systemRootImpl() {
        if (SYSTEM_ROOT == null) {
            SYSTEM_ROOT = new SystemPreferences();
        }
        assert (SYSTEM_ROOT != null);
        return SYSTEM_ROOT;
    }

    private NbPreferences(boolean user) {
        super(null, "");
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.fileStorage.attachChangeListener(this);
    }

    private NbPreferences(NbPreferences parent, String name) {
        super(parent, name);
        this.fileStorage = this.getFileStorage(this.absolutePath());
        this.newNode = !this.fileStorage.existsNode();
        this.fileStorage.attachChangeListener(this);
    }

    @Override
    protected final String getSpi(String key) {
        return this.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.properties().getProperty(key);
        }
    }

    @Override
    protected final String[] childrenNamesSpi() throws BackingStoreException {
        return this.fileStorage.childrenNames();
    }

    @Override
    protected final String[] keysSpi() throws BackingStoreException {
        return this.getKeysSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getKeysSpi() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            Set keySet = this.properties().keySet();
            return keySet.toArray(new String[0]);
        }
    }

    @Override
    protected final void putSpi(String key, String value) {
        this.putProperty(key, value);
        if (Boolean.TRUE.equals(this.localThread.get())) {
            return;
        }
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putProperty(String key, String value) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().put(key, value);
        }
    }

    @Override
    public void put(String key, String value) {
        this.put(key, value, false);
    }

    public void put(String key, String value, boolean triggeredByStateChangedEvent) {
        String oldValue = this.getSpi(key);
        if (value.equals(oldValue)) {
            return;
        }
        try {
            if (super.isRemoved()) {
                return;
            }
            ArrayList<String> cachedValues = this.cachedKeyValues.get(key);
            if (cachedValues == null) {
                cachedValues = new ArrayList();
            }
            if (triggeredByStateChangedEvent) {
                if (cachedValues.contains(value)) {
                    return;
                }
            } else {
                cachedValues.add(value);
                if (cachedValues.size() > 1000) {
                    cachedValues.subList(0, 900).clear();
                }
                this.cachedKeyValues.put(key, cachedValues);
            }
            super.put(key, value);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().contains("too long")) {
                this.putSpi(key, value);
            }
            throw iae;
        }
    }

    @Override
    protected final void removeSpi(String key) {
        this.removeProperty(key);
        this.keyEntries.remove(key);
        this.cachedKeyValues.remove(key);
        if (Boolean.TRUE.equals(this.localThread.get())) {
            return;
        }
        this.fileStorage.markModified();
        this.asyncInvocationOfFlushSpi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProperty(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.properties().remove((Object)key);
        }
    }

    @Override
    protected final void removeNodeSpi() throws BackingStoreException {
        try {
            this.fileStorage.removeNode();
        }
        catch (IOException ex) {
            throw new BackingStoreException(ex);
        }
    }

    private void asyncInvocationOfFlushSpi() {
        if (!this.fileStorage.isReadOnly()) {
            this.flushTask.schedule(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.fileStorage.save(this.properties());
            }
        }
        catch (IOException ex) {
            throw new BackingStoreException(ex);
        }
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.properties != null) {
            try {
                this.putAllProperties(this.fileStorage.load(), true);
            }
            catch (IOException ex) {
                throw new BackingStoreException(ex);
            }
        }
    }

    private EditableProperties properties() {
        if (this.properties == null) {
            this.properties = new EditableProperties(true);
            try {
                this.putAllProperties(this.fileStorage.load(), false);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAllProperties(EditableProperties props, boolean clear) {
        Object object = this.lock;
        synchronized (object) {
            if (clear) {
                this.properties().clear();
            }
            this.properties().putAll((Map)props);
        }
    }

    @Override
    public final void removeNode() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        if (super.isRemoved()) {
            return;
        }
        this.clearProperties();
        super.removeNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProperties() {
        Object object = this.lock;
        synchronized (object) {
            this.properties().clear();
            this.keyEntries.clear();
            this.cachedKeyValues.clear();
        }
    }

    @Override
    public final void flush() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        super.flush();
        this.cachedKeyValues.clear();
    }

    @Override
    public final void sync() throws BackingStoreException {
        if (this.fileStorage.isReadOnly()) {
            throw new BackingStoreException("Unsupported operation: read-only storage");
        }
        if (super.isRemoved()) {
            return;
        }
        this.flushTask.waitFinished();
        super.sync();
        this.cachedKeyValues.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        Object object = this.lock;
        synchronized (object) {
            Boolean previewState = this.localThread.get();
            EditableProperties ep = null;
            ArrayList<String> entries2add = new ArrayList<String>();
            try {
                this.localThread.set(Boolean.TRUE);
                ep = this.fileStorage.load();
                for (Map.Entry entry : ep.entrySet()) {
                    if (!this.keyEntries.isEmpty() && !this.keyEntries.contains(entry.getKey().toString())) continue;
                    this.put(entry.getKey().toString(), entry.getValue().toString(), true);
                    entries2add.add(entry.getKey().toString());
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                ArrayList<String> entries2remove = new ArrayList<String>();
                for (String key : this.keyEntries) {
                    if (entries2add.contains(key) || super.isRemoved()) continue;
                    entries2remove.add(key);
                }
                for (String key : entries2remove) {
                    this.remove(key);
                }
                this.keyEntries.clear();
                this.keyEntries.addAll(entries2add);
                this.localThread.set(previewState);
            }
        }
    }

    protected abstract FileStorage getFileStorage(String var1);

    static {
        RP = new RequestProcessor();
    }

    public static class UserPreferences
    extends NbPreferences {
        public UserPreferences() {
            super(true);
        }

        private UserPreferences(NbPreferences parent, String name) {
            super(parent, name);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            return new UserPreferences(this, name);
        }

        @Override
        protected FileStorage getFileStorage(String absolutePath) {
            return PropertiesStorage.instance(FileUtil.getConfigRoot(), this.absolutePath());
        }
    }

    private static final class SystemPreferences
    extends NbPreferences {
        private SystemPreferences() {
            super(false);
        }

        private SystemPreferences(NbPreferences parent, String name) {
            super(parent, name);
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            return new SystemPreferences(this, name);
        }

        @Override
        protected FileStorage getFileStorage(String absolutePath) {
            return PropertiesStorage.instanceReadOnly(FileUtil.getSystemConfigRoot(), this.absolutePath());
        }
    }

    static interface FileStorage {
        public boolean isReadOnly();

        public String[] childrenNames();

        public boolean existsNode();

        public void removeNode() throws IOException;

        public void markModified();

        public EditableProperties load() throws IOException;

        public void save(EditableProperties var1) throws IOException;

        public void runAtomic(Runnable var1);

        public void attachChangeListener(ChangeListener var1);
    }
}

